package com.hupu.tv.player.app.ui.fragment

import android.os.Bundle
import android.view.View
import androidx.fragment.app.Fragment
import androidx.recyclerview.widget.RecyclerView
import com.flyco.tablayout.utils.FragmentBasePager2Adapter

import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.adapter.SpecialistLabelAdapter
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.utils.ActivityManager
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import kotlinx.android.synthetic.main.fragment_specialist_material.*
import org.greenrobot.eventbus.EventBus


/**
 * @author by Dell
 * @date on 2020/6/14
 * @describe
 */
class SpecialistMaterialFragment : RefreshVP2Fragment<IBasePresenter>(),
    IBaseDisplay {
    private var specialistId = ""
    private var mFragments = ArrayList<Fragment>()
    private var recentList:ArrayList<String?>? = arrayListOf()
    override val layoutId: Int
        get() = R.layout.fragment_specialist_material


    override fun initEventAndData() {
        initRecyclerView()

        specialistId = arguments?.getString(CategoryBean.ID).orEmpty()
        recentList = arguments?.getStringArrayList(Constants.SPECIALIST_LIST) ?: arrayListOf()
        initViewPager(defaultList())
        initAdapter()

    }

    private fun initAdapter() {
        recycler_label.apply {
            adapter = SpecialistLabelAdapter().apply {
                setNewData(recentList)
            }
            ActivityManager.instance.getCurrent<BaseActivity<*>>()?.let {
                RecyclerViewUtil.addItemDecoration(
                    it,this,R.color.transparent,19,RecyclerView.HORIZONTAL)
            }
        }
    }

    override fun lazyLoad() {

    }

    private fun initViewPager(list: List<TitleSortBean>) {
        val mTitles = arrayOfNulls<String>(list.size)
        list.forEachIndexed { index, titleSortBean ->
            mTitles[index] = titleSortBean.sportsName
            mFragments.add(
                ChildSpecilistMaterialFragment.newInstance(
                    titleSortBean.sportsId,
                    titleSortBean.sportsName,
                    titleSortBean.extendId
                )
            )

        }
        val fragmentAdapter =
            FragmentBasePager2Adapter(childFragmentManager, mFragments, mTitles, lifecycle)
        vp_specialist.adapter = fragmentAdapter
        tabLayout_specialist_material.setViewPager2(vp_specialist)
    }


    companion object {
        fun newInstance(
            id: String,
            title: String,
            recentList: ArrayList<String?>?
        ): SpecialistMaterialFragment {
            val args = Bundle()
            val fragment = SpecialistMaterialFragment()
            args.putString(CategoryBean.ID, id)
            args.putString(CategoryBean.TITLE, title)
            args.putStringArrayList(Constants.SPECIALIST_LIST, recentList)
            fragment.arguments = args
            return fragment
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        EventBus.getDefault().unregister(this)
    }

    private fun defaultList(): MutableList<TitleSortBean> {
        return mutableListOf<TitleSortBean>().apply {
            add(TitleSortBean().apply {
                sportsName = Constants.MATCH_FOOTBALL_TEXT
                sportsId = Constants.SPORT_TYPE_FOOTBALL.toString()
                extendId = specialistId
            })

            add(TitleSortBean().apply {
                sportsName = Constants.MATCH_BASKETBALL_TEXT
                sportsId = Constants.SPORT_TYPE_BASKETBALL.toString()
                extendId = specialistId
            })

        }
    }

}