package com.hupu.tv.player.app.ui.fragment

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView

import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshVP2Fragment
import com.hupu.tv.player.app.base.ToolbarFragment
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.event.FollowAnchorEvent
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.ui.activity.LiveActivity
import com.hupu.tv.player.app.ui.activity.MaterialDetailActivity
import com.hupu.tv.player.app.ui.activity.NewsDetailActivity
import com.hupu.tv.player.app.ui.adapter.*
import com.hupu.tv.player.app.ui.contact.FollowAnchorContract
import com.hupu.tv.player.app.ui.contact.HaveMaterialContract
import com.hupu.tv.player.app.ui.contact.SpecilistNewsContract
import com.hupu.tv.player.app.ui.presenter.FollowAnchorPresenter
import com.hupu.tv.player.app.ui.presenter.HaveMaterialPresenter
import com.hupu.tv.player.app.ui.presenter.MainHaveMaterialPresenter
import com.hupu.tv.player.app.ui.presenter.SpecilistNewsPresenter
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.EmptyConfig
import com.kongzue.dialog.v3.WaitDialog
import com.softgarden.baselibrary.utils.ToastUtil
import kotlinx.android.synthetic.main.fragment_follow_content.*
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode


/**
 * @author by Dell
 * @date on 2020/6/14
 * @describe
 */
class SpecialistNewsFragment : RefreshVP2Fragment<SpecilistNewsPresenter>(),
    SpecilistNewsContract.Display {
    private var sportId = ""
    private lateinit var mAdapter: NewsListAdapter
    override val layoutId: Int
        get() = R.layout.fragment_specialist_news


    override fun initEventAndData() {
        initRecyclerView()
        initRefreshLayout()
        initAdapter()
        arguments?.getString(CategoryBean.ID)?.let {
            sportId = it
        }
        initStatusLayout(mRefreshLayout as View)
        mStatusLayoutManager.showLoadingLayout()

    }

    private fun initAdapter() {
        mRecyclerView?.apply {
            mAdapter = NewsListAdapter().apply {
                setOnItemClickListener { adapter, view, position ->
                    startActivity(Intent(requireContext(), NewsDetailActivity::class.java).apply {
                        putExtra(
                            Constants.NEWS_DETAIL,
                            (adapter.getItem(position) as NewsListEntity).id.toString()
                        )
                    })
                }
            }
            adapter = mAdapter
            RecyclerViewUtil.addItemDecoration(requireActivity(), this, R.color.transparent, Constants.item_divider_4 * 2)
        }


    }

    override fun lazyLoad() {
        presenter?.getNewsList("0", mPage)
    }


    companion object {
        fun newInstance(id: String, title: String): SpecialistNewsFragment {
            val args = Bundle()
            val fragment = SpecialistNewsFragment()
            args.putString(CategoryBean.ID, id)
            args.putString(CategoryBean.TITLE, title)
            fragment.arguments = args
            return fragment
        }
    }


    override fun onNewsData(data: NewsDataBean?) {
        mStatusLayoutManager.showSuccessLayout()
        setLoadMore(mAdapter, data?.dataList)
    }

}