package com.hupu.tv.player.app.ui.im;

import android.content.Context;

import com.hyphenate.chat.EMGroupReadAck;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.easeui.manager.EaseChatPresenter;
import com.hyphenate.util.EMLog;
import com.hupu.tv.player.app.app.App;
import com.hupu.tv.player.app.event.MessageEvent;

import org.greenrobot.eventbus.EventBus;

import java.util.List;

/**
 * 主要用于chat过程中的全局监听，并对相应的事件进行处理
 * {@link #init()}方法建议在登录成功以后进行调用
 */
public class ChatPresenter extends EaseChatPresenter {
    private static final String TAG = ChatPresenter.class.getSimpleName();
    private static final int HANDLER_SHOW_TOAST = 0;
    private static ChatPresenter instance;
    private Context appContext;


    private ChatPresenter() {
        appContext = App.Companion.getInstance();

    }

    public static ChatPresenter getInstance() {
        if (instance == null) {
            synchronized (ChatPresenter.class) {
                if (instance == null) {
                    instance = new ChatPresenter();
                }
            }
        }
        return instance;
    }

    /**
     * 将需要登录成功进入MainActivity中初始化的逻辑，放到此处进行处理
     */
    public void init() {

    }


    @Override
    public void onMessageReceived(List<EMMessage> messages) {
        super.onMessageReceived(messages);
        for (EMMessage message : messages) {
            EMLog.d(TAG, "onMessageReceived id : " + message.getMsgId());
            EMLog.d(TAG, "onMessageReceived: " + message.getType());
//            String from = message.getFrom();
//            EaseUser easeUser = new EaseUser(from);
//            String userNick = message.getStringAttribute(Constants.USER_NICK, "");
//            String userAvatar = message.getStringAttribute(Constants.USER_AVATAR, "");
            EMTextMessageBody body = (EMTextMessageBody) message.getBody();
            EventBus.getDefault().post(new MessageEvent(body.getMessage()));
//            String encode = new EncodeUtils2().decode(body.getMessage());
//            body.setMessage(encode);
//            easeUser.setAvatar(userAvatar);
//            easeUser.setNickname(userNick);
//            easeUser.setUsername(from);
//            Map<String, EaseUser> contactList = DemoHelper.getInstance().getContactList();
//            contactList.put(from, easeUser);
            //todo  保存接受信息，但未必是联系人
//            List<EaseUser> users = new ArrayList<>();
//            if (DemoHelper.getInstance().isContactsList(from)) {
//                easeUser.setContact(0);
//            } else {
//                easeUser.setContact(2);
//            }
//            users.add(easeUser);
//            DemoModel model = DemoHelper.getInstance().getModel();
//            model.saveContactList(users);
//            model.setContactSynced(true);

            //notify new message
            getNotifier().vibrateAndPlayTone(message);
        }
    }

    @Override
    public void onMessageDelivered(List<EMMessage> messages) {
        super.onMessageDelivered(messages);
        int i = 0;
    }

    @Override
    public void onMessageChanged(EMMessage message, Object change) {
        super.onMessageChanged(message, change);
        int i = 0;
    }

    @Override
    public void onMessageRead(List<EMMessage> messages) {
        super.onMessageRead(messages);
        int i = 0;
    }

    @Override
    public void onMessageRecalled(List<EMMessage> messages) {
        super.onMessageRecalled(messages);
        int i = 0;
    }

    @Override
    public void onCmdMessageReceived(List<EMMessage> messages) {
        super.onCmdMessageReceived(messages);
        int i = 0;
    }

    @Override
    public void onGroupMessageRead(List<EMGroupReadAck> groupReadAcks) {
        super.onGroupMessageRead(groupReadAcks);
        int i = 0;
    }

    @Override
    public void onReadAckForGroupMessageUpdated() {
        super.onReadAckForGroupMessageUpdated();
        int i = 0;
    }
}
