package com.hupu.tv.player.app.ui.im;

import android.content.Context;
import android.graphics.Color;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.view.View;
import android.widget.TextView;

import com.blankj.utilcode.util.SpanUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.easeui.modules.chat.EaseChatMessageListLayout;
import com.hyphenate.easeui.modules.chat.model.EaseChatItemStyleHelper;
import com.hyphenate.easeui.modules.chat.model.EaseChatSetStyle;
import com.hyphenate.easeui.utils.EaseSmileUtils;
import com.hyphenate.easeui.utils.EaseUserUtils;
import com.hyphenate.easeui.widget.chatrow.EaseChatRowText;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.app.Constants;


/**
 * @author by Dell
 * @date on 2021/3/23
 * @describe
 */
public class CustomTextRow extends EaseChatRowText {
    private TextView tvLevel;
    private TextView contentView;

    public CustomTextRow(Context context, boolean isSender) {
        super(context, isSender);
    }

    public CustomTextRow(Context context, EMMessage message, int position, Object adapter) {
        super(context, message, position, adapter);
    }

    @Override
    protected void onFindViewById() {
        super.onFindViewById();
        tvLevel = findViewById(R.id.tv_level);
        contentView = (TextView) findViewById(R.id.tv_chatcontent);
    }

    @Override
    public void setTimestamp(EMMessage preMessage) {
        if (timeStampView != null) {
            super.setTimestamp(preMessage);
        }

    }

    @Override
    public void onSetUpView() {
        EMTextMessageBody txtBody = (EMTextMessageBody) message.getBody();
        Spannable span = EaseSmileUtils.getSmiledText(context, txtBody.getMessage());
        // 设置内容
        String userNick = message.getStringAttribute(Constants.USER_NICK, message.getFrom());
        if (position % 2 == 0) {
            findViewById(R.id.rl_bg).setBackgroundColor(Color.parseColor("#05CC4C50"));
        } else {
            findViewById(R.id.rl_bg).setBackgroundColor(Color.parseColor("#00000000"));
        }
        int level = message.getIntAttribute(Constants.USER_LEVEL, 1);
        SpannableStringBuilder content = SpanUtils
                .with(contentView)
                .appendImage(getLevel(level))
                .append("  " + userNick + "：")
                .setForegroundColor(getContext().getColor(R.color.user_nick))
                .append(span)
                .create();
        contentView.setText(content, TextView.BufferType.SPANNABLE);
    }

    @Override
    protected void setAvatarOptions(EaseChatSetStyle itemStyle) {
        super.setAvatarOptions(itemStyle);
        userAvatarView.setVisibility(View.GONE);
    }

    @Override
    protected void onInflateView() {
        inflater.inflate(R.layout.custom_row_received_message, this);
    }

    @Override
    protected void setAvatarAndNick() {

//        int level = message.getIntAttribute(Constants.USER_LEVEL, 1);
//
//        if (isSender()) {
//            EaseUserUtils.setUserAvatar(context, EMClient.getInstance().getCurrentUser(), userAvatarView);
//            //只要不是常规布局形式，就展示昵称
//            if (EaseChatItemStyleHelper.getInstance().getStyle().getItemShowType() != EaseChatMessageListLayout.ShowType.NORMAL.ordinal()) {
//                EaseUserUtils.setUserNick(userNick + " :", usernickView);
//                tvLevel.setText("LV." + level);
//            }
//        } else {
//            //todo 接受来的昵称
//            EaseUserUtils.setUserAvatar(context, message.getFrom(), userAvatarView);
//            EaseUserUtils.setUserNick(userNick + ":", usernickView);
//            tvLevel.setText("LV." + level);
//        }
    }

    //    @Override
//    public void onSetUpView() {
//        EMTextMessageBody txtBody = (EMTextMessageBody) message.getBody();
//        boolean messageEncode = message.getBooleanAttribute(Constants.MESSAGE_ENCODE, false);
//        String decode = "";
//        if (messageEncode){
//            decode = txtBody.getMessage();
//        }else{
//            decode = new EncodeUtils2().decode(txtBody.getMessage());
//        }
//        Spannable span = EaseSmileUtils.getSmiledText(context, decode);
//        // 设置内容
//        contentTextView.setText(span, TextView.BufferType.SPANNABLE);
//    }
    private int getLevel(int level) {
        int levelIcon = R.mipmap.icon_user_level_1;
        switch (level) {
            case 1:
                levelIcon = R.mipmap.icon_user_level_1;
                break;
            case 2:
                levelIcon = R.mipmap.icon_user_level_2;
                break;
            case 3:
                levelIcon = R.mipmap.icon_user_level_3;
                break;
            case 4:
                levelIcon = R.mipmap.icon_user_level_4;
                break;
            case 5:
                levelIcon = R.mipmap.icon_user_level_5;
                break;
            case 6:
                levelIcon = R.mipmap.icon_user_level_6;
                break;
            case 7:
                levelIcon = R.mipmap.icon_user_level_7;
                break;
            case 8:
                levelIcon = R.mipmap.icon_user_level_8;
                break;
            case 9:
                levelIcon = R.mipmap.icon_user_level_9;
                break;
            case 10:
                levelIcon = R.mipmap.icon_user_level_10;
                break;
            case 11:
                levelIcon = R.mipmap.icon_user_level_11;
                break;
            case 12:
                levelIcon = R.mipmap.icon_user_level_12;
                break;
            case 13:
                levelIcon = R.mipmap.icon_user_level_13;
                break;
            case 14:
                levelIcon = R.mipmap.icon_user_level_14;
                break;
            case 15:
                levelIcon = R.mipmap.icon_user_level_15;
                break;
            case 16:
                levelIcon = R.mipmap.icon_user_level_16;
                break;
            case 17:
                levelIcon = R.mipmap.icon_user_level_17;
                break;
            case 18:
                levelIcon = R.mipmap.icon_user_level_18;
                break;
            case 19:
                levelIcon = R.mipmap.icon_user_level_19;
                break;
            case 20:
                levelIcon = R.mipmap.icon_user_level_20;
                break;
            case 21:
                levelIcon = R.mipmap.icon_user_level_21;
                break;
            case 22:
                levelIcon = R.mipmap.icon_user_level_22;
                break;
            case 23:
                levelIcon = R.mipmap.icon_user_level_23;
                break;
            case 24:
                levelIcon = R.mipmap.icon_user_level_24;
                break;
            case 25:
                levelIcon = R.mipmap.icon_user_level_25;
                break;
            case 26:
                levelIcon = R.mipmap.icon_user_level_26;
                break;
            case 27:
                levelIcon = R.mipmap.icon_user_level_27;
                break;
            case 28:
                levelIcon = R.mipmap.icon_user_level_28;
                break;
            case 29:
                levelIcon = R.mipmap.icon_user_level_29;
                break;
            case 30:
                levelIcon = R.mipmap.icon_user_level_30;
                break;
            case 31:
                levelIcon = R.mipmap.icon_user_level_31;
                break;
            case 32:
                levelIcon = R.mipmap.icon_user_level_32;
                break;
            case 33:
                levelIcon = R.mipmap.icon_user_level_33;
                break;
            case 34:
                levelIcon = R.mipmap.icon_user_level_34;
                break;
            case 35:
                levelIcon = R.mipmap.icon_user_level_35;
                break;
            case 36:
                levelIcon = R.mipmap.icon_user_level_36;
                break;


        }
        return levelIcon;

    }
}
