package com.hupu.tv.player.app.ui.presenter

import android.util.Log
import com.hupu.tv.player.app.BuildConfig
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.LiveUserBean
import com.hupu.tv.player.app.ui.contact.AccountBindNewPhoneContact
import com.hupu.tv.player.app.utils.JsonUtils
import com.hupu.tv.player.app.utils.UserHelper

/**
 * @author by Dell
 * @date on 2020/8/31
 * @describe
 */
class AccountBindNewPhonePresenter : IBasePresenter, AccountBindNewPhoneContact.Presenter {
    private var mView: AccountBindNewPhoneContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as AccountBindNewPhoneContact.Display
    }

    override fun detachView() {

    }

    override fun bindNewPhone(smsCode: String, phone: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["smsCode"] = smsCode
        hashMap["phone"] = phone
        RetrofitClient.retrofitService
            .bindNewPhone(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    login(phone, smsCode)
                }
            })
    }

    override fun getSmsCode(phone: String) {
        Log.e("sms", "smsAccount")
        val hashMap = HashMap<String, Any>()
        hashMap["phone"] = phone
        RetrofitClient.retrofitService
            .getSmsCode(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                }

            })
    }

    fun login(phone: String, smsCode: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["channelId"] = SPUtil[Constants.CHANNEL_ID, BuildConfig.CHANNEL_ID]
        hashMap["nickName"] = ""
        hashMap["smsCode"] = smsCode
        hashMap["phone"] = phone
        hashMap["userAvatar"] = ""
        RetrofitClient.retrofitService
            .loginLive(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    UserHelper.userLoginSaveToken(data)
                    getUserInfo(phone)
                }
            })
    }

    private fun getUserInfo(phone: String) {
        RetrofitClient.retrofitService
            .getUserInfo()
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<LiveUserBean>() {
                override fun onSuccess(data: LiveUserBean?) {
                    UserHelper.userLoginSuccessForPhone(data, phone)
                    mView?.onBind()
                }
            })
    }
}