package com.hupu.tv.player.app.ui.presenter

import android.util.Log
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.ui.contact.AccountBindContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/8/31
 * @describe
 */
class AccountBindPresenter : IBasePresenter, AccountBindContact.Presenter {
    private var mView: AccountBindContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as AccountBindContact.Display
    }

    override fun detachView() {

    }

    override fun verifySmsCode(smsCode: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["smsCode"] = smsCode
        RetrofitClient.retrofitService
                .verifyCode(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {
                        mView?.onSmsCodeSuccess()
                    }
                })
    }

    override fun getSmsCode(phone: String) {
        Log.e("sms","smsAccountBind")
        val hashMap = HashMap<String, Any>()
        hashMap["phone"] = phone
        RetrofitClient.retrofitService
                .getSmsCode(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {
                    }

                })
    }
}