package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.AllStarBean
import com.hupu.tv.player.app.ui.contact.AllStarFragmentContact

/**
 * @author by Dell
 * @date on 2020/8/31
 * @describe
 */
class AllStarFragmentPresenter : IBasePresenter, AllStarFragmentContact.Presenter {
    private var mView: AllStarFragmentContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as AllStarFragmentContact.Display
    }

    override fun detachView() {

    }

    override fun getAllStar() {
        RetrofitClient.retrofitService
                .getAllStar()
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<AllStarBean>() {
                    override fun onSuccess(data: AllStarBean?) {
                        mView?.onRequestData(data)
                    }
                })
    }
}