package com.hupu.tv.player.app.ui.presenter

import android.os.CountDownTimer
import com.hupu.tv.player.app.BuildConfig
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.UserBean
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.ui.contact.BindPhoneContact
import com.hupu.tv.player.app.utils.JsonUtils
import org.greenrobot.eventbus.EventBus

/**
 * @author by Dell
 * @date on 2020/7/13
 * @describe
 */
class BindPhonePresenter : IBasePresenter, BindPhoneContact.Presenter {
    var mView: BindPhoneContact.Display? = null
    private var countDownTimer: CountDownTimer? = null

    companion object {
        const val TOTAL_TIME = 60000L
        const val ONCE_TIME = 1000L
    }

    override fun attachView(view: IBaseDisplay?) {
        mView = view as BindPhoneContact.Display?
    }

    override fun detachView() {

    }

    override fun getCode(phoneNumber: String) {
        startCountDownTimer()
        requestCode(phoneNumber)
    }

    override fun commitBindPhone(verifyCode:String) {
        val hashMap = HashMap<String, Any>()
        hashMap["verifyCode"] = verifyCode
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .bindPhone(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {
                        refreshUser()
                    }
                })
    }
    private fun refreshUser() {
        val hashMap = HashMap<String, Any>()
        hashMap["channel"] = SPUtil[Constants.CHANNEL_ID, BuildConfig.CHANNEL_ID]
        hashMap["code"] = SPUtil[Constants.SHARE_CODE,""] as String
        RetrofitClient.retrofitService
                .login(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<UserBean>() {
                    override fun onSuccess(data: UserBean?) {
                        SPUtil.putSerializableObject(Constants.USER_BEAN, data)
                        SPUtil.put(Constants.USER_ID, data?.id)
                        EventBus.getDefault().post(RefreshUserEvent())
                        mView?.onBindFinish()
                    }
                })
    }

    private fun requestCode(phoneNumber: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["mobileNo"] = phoneNumber
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .getVerifyCode(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {

                    }
                })
    }

    private fun startCountDownTimer() {
        countDownTimer = object : CountDownTimer(TOTAL_TIME, ONCE_TIME) {
            override fun onFinish() {
                mView?.onFinish()
            }

            override fun onTick(millisUntilFinished: Long) {
                mView?.onTick(millisUntilFinished / 1000)
            }
        }
        countDownTimer?.start()
    }
}