package com.hupu.tv.player.app.ui.presenter


import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.LiveUserBean
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.ui.contact.EditNickContact
import com.hupu.tv.player.app.utils.JsonUtils
import com.hupu.tv.player.app.utils.UserHelper
import org.greenrobot.eventbus.EventBus

/**
 * @author by Dell
 * @date on 2021/3/12
 * @describe
 */
class EditNickPresenter : IBasePresenter, EditNickContact.presenter {
    private var mView: EditNickContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as EditNickContact.Display?
    }

    override fun detachView() {

    }


    override fun editInfo(nickName: String, sex: Int, birthday: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["description"] = ""
        hashMap["nickName"] = nickName
        hashMap["sex"] = sex
        hashMap["birthday"] = birthday

        RetrofitClient.retrofitService
            .editUser(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    getUserInfo()
                }
            })
    }

    private fun getUserInfo() {
        RetrofitClient.retrofitService
            .getUserInfo()
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<LiveUserBean>() {
                override fun onSuccess(data: LiveUserBean?) {
                    UserHelper.userLoginSuccess(data)
                    mView?.onSuccess()
                }
            })
    }
}