package com.hupu.tv.player.app.ui.presenter


import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.ui.contact.EdittPasswordActivityContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/7/1
 * @describe
 */
class EdittPasswordActivityPresenter : IBasePresenter, EdittPasswordActivityContact.Present {
    private var mView: EdittPasswordActivityContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as EdittPasswordActivityContact.Display?
    }

    override fun detachView() {
    }


    override fun editPassword(phone: String, smsCode: String, password: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["phone"] = phone
        hashMap["smsCode"] = smsCode
        hashMap["password"] = password
        RetrofitClient.retrofitService
            .forgetPassword(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    mView?.onEditPassword()
                }

            })
    }

    override fun getSmsCode(phone: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["phone"] = phone
        RetrofitClient.retrofitService
                .getSmsCode(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {
                    }

                })
    }




}