package com.hupu.tv.player.app.ui.presenter

import com.hupu.tv.player.app.BuildConfig
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.UserBean
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.ui.contact.ExchangeCodeActivityContact
import com.hupu.tv.player.app.utils.JsonUtils
import org.greenrobot.eventbus.EventBus

/**
 * @author by Dell
 * @date on 2020/7/5
 * @describe
 */
class ExchangeCodeActivityPresenter :IBasePresenter,ExchangeCodeActivityContact.Presenter {
    private var mView:ExchangeCodeActivityContact.Display?=null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as ExchangeCodeActivityContact.Display?
    }

    override fun detachView() {

    }

    override fun exchangeCode(code:String) {
        val hashMap = HashMap<String, Any>()
        hashMap["userId"]= SPUtil[Constants.USER_ID, 0] as Int
        hashMap["exchangeCode"]= code
        RetrofitClient.retrofitService
                .exchangeCode(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<Boolean>(){
                    override fun onSuccess(data: Boolean?) {
                        refreshUserInfo()
                    }
                })

    }

    override fun refreshUserInfo() {
        val hashMap = HashMap<String, Any>()
        hashMap["channel"] = SPUtil[Constants.CHANNEL_ID, BuildConfig.CHANNEL_ID]
        hashMap["code"] = SPUtil[Constants.SHARE_CODE,""] as String
        RetrofitClient.retrofitService
                .login(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<UserBean>(){
                    override fun onSuccess(data: UserBean?) {
                        data?.let {
                            SPUtil.putSerializableObject(Constants.USER_BEAN,it)
                            SPUtil.put(Constants.USER_ID,it.id)
                            EventBus.getDefault().post(RefreshUserEvent())
                            mView?.onExchangeCode()
                        }
                    }
                })
    }
}