package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.contact.FollowAnchorContract
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class FollowAnchorPresenter : IBasePresenter, FollowAnchorContract.Presenter {
    private var mView: FollowAnchorContract.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as FollowAnchorContract.Display?
    }

    override fun detachView() {

    }
    override fun getAnchorList() {
        RetrofitClient.retrofitService
                .getMatchAnchor()
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<List<AnchorEntity>>() {
                    override fun onSuccess(data: List<AnchorEntity>?) {
                        data?.let {
                            mView?.onAnchorList(it)
                        }
                    }
                })
    }

    override fun getRecommendList(mPage:Int,roomId:String) {
        val hashMap = HashMap<String, Any>()
        hashMap["pageNum"]=mPage
        hashMap["pageSize"]=10
        hashMap["roomId"]=roomId
        RetrofitClient.retrofitService
                .getRecommendList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<LiveBean>() {
                    override fun onSuccess(data: LiveBean?) {
                        data?.let {
                            mView?.onRecommendList(it.dataList)
                        }
                    }
                })
    }

}