package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.MatchContentEntity
import com.hupu.tv.player.app.bean.MatchInfoEntity
import com.hupu.tv.player.app.ui.contact.FollowMatchContract
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class FollowMatchPresenter : IBasePresenter, FollowMatchContract.Presenter {
    private var mView: FollowMatchContract.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as FollowMatchContract.Display?
    }

    override fun detachView() {

    }

    override fun getMatchOrder() {
        RetrofitClient.retrofitService
            .getMatchReserve()
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<MatchContentEntity>() {
                override fun onSuccess(data: MatchContentEntity?) {
                    if (data?.matchLists?.size ?: 0 > 0) {
                        mView?.onMatchList(arrayListOf<MatchInfoEntity>().apply {
                            data?.matchLists?.forEach {
                                addAll(it.matchInfos)
                            }
                        })
                    } else {
                        mView?.onMatchList(null)
                    }
                }
            })

    }


    override fun reserveMatch(id: String,position:Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
            .reserveMatch(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    mView?.onSubscribeMatch(id,true,position)
                }
            })
    }

    override fun reserveMatch(id: String, status: Boolean,position:Int) {
        if (status) {
            reserveMatch(id,position)
        } else {
            cancelReserveMatch(id,position)
        }
    }

    override fun cancelReserveMatch(id: String,position:Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
            .cancelReserve(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    mView?.onSubscribeMatch(id,false,position)
                }
            })
    }

}