package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.contact.HaveMaterialContract
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class HaveMaterialPresenter : IBasePresenter, HaveMaterialContract.Presenter {
    private var mView: HaveMaterialContract.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as HaveMaterialContract.Display?
    }

    override fun detachView() {

    }


    override fun getSpecialist(expertId: String, pageNum: Int, pageSize: Int, type: Int) {
        RetrofitClient.retrofitService
            .getBallMaterial(JsonUtils.toRequestBody(hashMapOf<String, Any>().apply {
                put("expertId", expertId)
                put("pageNum", pageNum)
                put("pageSize", pageSize)
                put("type", type)
            }))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<SpecialBallBean>() {
                override fun onSuccess(data: SpecialBallBean?) {
                    mView?.onSpecialist(data?.dataList)
                }
            })
    }
}