package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.FakeMessageEntity
import com.hupu.tv.player.app.bean.HistoryMessageEntity
import com.hupu.tv.player.app.bean.RoomInfoEntity
import com.hupu.tv.player.app.ui.contact.LiveActivityContact
import com.hupu.tv.player.app.utils.JsonUtils
import com.softgarden.baselibrary.utils.SPUtil


/**
 * @author by Dell
 * @date on 2020/7/13
 * @describe
 */
class LiveActivityPresenter : IBasePresenter, LiveActivityContact.Presenter {
    private var mView: LiveActivityContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as LiveActivityContact.Display?
    }

    override fun detachView() {

    }

    override fun getFakeMessage() {
        RetrofitClient.retrofitService
            .getFakeMessage()
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<FakeMessageEntity>() {
                override fun onSuccess(data: FakeMessageEntity?) {
                    SPUtil.putSerializableObject(Constants.FAKE_MESSAGE, data)
                }
            })
    }


    override fun getRoomInfo(id: String) {
        val hashMap = HashMap<String, String>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
            .getRoomInfo(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<RoomInfoEntity>() {
                override fun onSuccess(data: RoomInfoEntity?) {
                    mView?.onRequestRoomInfo(data)
                }
            })
    }


    override fun followAnchor(id: String) {
        val hashMap = HashMap<String, String>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
            .followAnchor(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    mView?.onFollowAnchor("已关注主播", true)
                }
            })
    }

    override fun unFollowAnchor(id: String) {
        val hashMap = HashMap<String, String>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
            .unfollowAnchor(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    mView?.onFollowAnchor("已取消关注主播", false)
                }
            })
    }

    override fun sendGift(giftId: Int, roomId: String, position: Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["giftId"] = giftId
        hashMap["roomId"] = roomId
        RetrofitClient.retrofitService
            .sendGift(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    mView?.onSendGift(giftId, position)
                }

//                    override fun onError(t: Throwable) {
//                        super.onError(t)
//                        mView?.onSendGift(giftId,position)
//                    }
            })


    }

    override fun getHistoryMessage(id: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
            .getHistoryMessage(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<List<HistoryMessageEntity>>() {
                override fun onSuccess(data: List<HistoryMessageEntity>?) {
                    mView?.onHistoryMessage(data)
                }
            })
    }


}