package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.RoomInfoBean
import com.hupu.tv.player.app.bean.RoomInfoEntity
import com.hupu.tv.player.app.ui.contact.LiveAnchorFragmentContact
import com.hupu.tv.player.app.utils.JsonUtils


/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class LiveAnchorFragmentPresenter : IBasePresenter, LiveAnchorFragmentContact.Presenter {
    private var mView: LiveAnchorFragmentContact.Display? = null

    override fun attachView(view: IBaseDisplay?) {
        mView = view as LiveAnchorFragmentContact.Display?
    }

    override fun detachView() {

    }

    override fun getRoomInfo(id: String) {
        val hashMap = HashMap<String, String>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
                .getRoomInfo(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView,false))
                .subscribe(object : RxCallback<RoomInfoEntity>() {
                    override fun onSuccess(data: RoomInfoEntity?) {
                        mView?.onRequestRoomInfo(data)
                    }
                })
    }


}