package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.GiftBean
import com.hupu.tv.player.app.bean.LiveUserBean
import com.hupu.tv.player.app.ui.contact.LiveConversationFragmentContact
import com.hupu.tv.player.app.utils.JsonUtils


/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class LiveConversationFragmentPresenter : IBasePresenter, LiveConversationFragmentContact.Presenter {
    private var mView: LiveConversationFragmentContact.IDisplay? = null

    override fun attachView(view: IBaseDisplay?) {
        mView = view as LiveConversationFragmentContact.IDisplay?
    }

    override fun detachView() {

    }

    override fun getGiftList() {
        RetrofitClient.retrofitService
                .getGiftList()
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<List<GiftBean>>() {
                    override fun onSuccess(data: List<GiftBean>?) {
                        mView?.onRequestList(data as ArrayList<GiftBean>)
                    }
                })
    }

    override fun getMemberById(list: ArrayList<String>) {
        val hashMap = HashMap<String, Any>()
        hashMap["userIds"] = list
        RetrofitClient.retrofitService
                .getUserInfoByIds(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<List<LiveUserBean>>() {
                    override fun onSuccess(data: List<LiveUserBean>?) {
                        mView?.onMemberJoinRoom(data as ArrayList<LiveUserBean>)
                    }
                })
    }


}