package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.MatchContentBean
import com.hupu.tv.player.app.ui.contact.LiveMatchFragmentContact
import com.hupu.tv.player.app.utils.JsonUtils


/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class LiveMatchFragmentPresenter : IBasePresenter, LiveMatchFragmentContact.Presenter {
    private var mView: LiveMatchFragmentContact.IDisplay? = null

    override fun attachView(view: IBaseDisplay?) {
        mView = view as LiveMatchFragmentContact.IDisplay?
    }

    override fun detachView() {

    }

    override fun getMatch(id: String) {
        val hashMap = HashMap<String, String>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
                .getAnchorMatch(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView,false))
                .subscribe(object : RxCallback<MatchContentBean>() {
                    override fun onSuccess(data: MatchContentBean?) {
                        data?.matchLists?.forEach {
                            val matchTime = it.matchTime
                            it.matchInfos.forEach {
                                it.matchDays = matchTime
                            }
                        }
                        mView?.onRequestMatch(data?.matchLists)
                    }
                })
    }

    override fun reserveMatch(id: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] =id
        RetrofitClient.retrofitService
                .reserveMatch(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {
                        mView?.onSubscribeMatch("预约成功")
                    }
                })
    }

    override fun reserveMatch(id: String, status: Boolean) {
        if (status){
            reserveMatch(id)
        }else{
            cancelReserveMatch(id)
        }
    }

    override fun cancelReserveMatch(id: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] =id
        RetrofitClient.retrofitService
                .cancelReserve(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {
                        mView?.onSubscribeMatch("取消成功")
                    }
                })
    }


}