package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.LiveRankBean
import com.hupu.tv.player.app.ui.contact.LiveRankFragmentContact
import com.hupu.tv.player.app.utils.JsonUtils


/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class LiveRankFragmentPresenter : IBasePresenter, LiveRankFragmentContact.Presenter {
    private var mView: LiveRankFragmentContact.IDisplay? = null

    override fun attachView(view: IBaseDisplay?) {
        mView = view as LiveRankFragmentContact.IDisplay?
    }

    override fun detachView() {

    }



    override fun getRank(id: String) {
        val hashMap = HashMap<String, String>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
                .getRankList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView,false))
                .subscribe(object : RxCallback<List<LiveRankBean>>() {
                    override fun onSuccess(data: List<LiveRankBean>?) {
                        mView?.onRequestRankList(data)
                    }
                })
    }


}