package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.MovieBean
import com.hupu.tv.player.app.bean.RedListEntity
import com.hupu.tv.player.app.bean.TextLiveBean
import com.hupu.tv.player.app.ui.contact.LiveRedListContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/7/13
 * @describe
 */
class LiveRedListPresenter : IBasePresenter, LiveRedListContact.Presenter {
    private var mView: LiveRedListContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as LiveRedListContact.Display?
    }

    override fun detachView() {

    }


    override fun getRedList(id: String, pageNum: Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["pageNum"] = pageNum
        hashMap["pageSize"] = 10
//        hashMap["matchId"] = "8d73671b8b384516a4d217ca4dab4bd0"
        hashMap["matchId"] = id
        RetrofitClient.retrofitService
            .getRedList(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<RedListEntity?>() {
                override fun onSuccess(data: RedListEntity?) {
                    mView?.onRequestList(data?.dataList)
                }
            })
    }
}