package com.hupu.tv.player.app.ui.presenter


import android.util.Log
import android.widget.TextView
import com.hupu.tv.player.app.BuildConfig
import com.kongzue.dialog.v3.WaitDialog
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.HostUrl
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.activity.MainActivity
import com.hupu.tv.player.app.ui.contact.LoginActivityContact
import com.hupu.tv.player.app.utils.JsonUtils
import com.hupu.tv.player.app.utils.UserHelper

/**
 * @author by Dell
 * @date on 2020/7/1
 * @describe
 */
class LoginActivityPresenter : IBasePresenter, LoginActivityContact.Present {
    private var mView: LoginActivityContact.Display? = null
    private var mTvMessage: TextView? = null
    private var list: ArrayList<AdBean>? = arrayListOf()
    override fun attachView(view: IBaseDisplay?) {
        mView = view as LoginActivityContact.Display?
    }

    override fun detachView() {
        list = null
        mTvMessage = null
    }

    override fun login(phone: String, nickName: String, smsCode: String, userAvatar: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["channelId"] = SPUtil[Constants.CHANNEL_ID, BuildConfig.CHANNEL_ID]
        hashMap["nickName"] = nickName
        hashMap["smsCode"] = smsCode
        hashMap["phone"] = phone
        hashMap["userAvatar"] = userAvatar
        mTvMessage?.text =
            mTvMessage?.text.toString() + "\n" + "请求login地址${SPUtil[Constants.HOST_URL, HostUrl.HOST_URL] as String + HostUrl.POST_LOGIN}\n请求login参数$hashMap "
        RetrofitClient.retrofitService
            .loginLive(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    UserHelper.userLoginSaveToken(data)
                    getUserInfo(phone)
                }

                override fun onError(t: Throwable) {
                    mTvMessage?.text = mTvMessage?.text.toString() + "\n" + "请求login失败${t.message}"
                    super.onError(t)
                    WaitDialog.dismiss()
//                        BaseDialog.unload()
                    if (t.message == Constants.LOGIN_ERROR_NICK) {
                        mView?.onWriteNickName()
                    }

//                        else {
//                            DialogUtils.showReContact(mView as AppCompatActivity, object : DialogUtils.OnClickSingleListener {
//                                override fun onClick() {
//                                    mTvMessage?.text = mTvMessage?.text.toString() + "\n" + "重新登录"
//                                    login(phone,nickName,smsCode,userAvatar)
//                                }
//                            })
//                        }
                }
            })
    }

    override fun loginPassword(phone: String, password: String) {
        val hashMap = HashMap<String, Any>()
//        hashMap["channelId"] = SPUtil[Constants.CHANNEL_ID, BuildConfig.CHANNEL_ID]
        hashMap["phone"] = phone
        hashMap["password"] = password
        mTvMessage?.text =
            mTvMessage?.text.toString() + "\n" + "请求login地址${SPUtil[Constants.HOST_URL, HostUrl.HOST_URL] as String + HostUrl.POST_LOGIN}\n请求login参数$hashMap "
        RetrofitClient.retrofitService
            .loginPassword(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    UserHelper.userLoginSaveToken(data)
                    getUserInfo(phone)
                }

                override fun onError(t: Throwable) {
                    mTvMessage?.text = mTvMessage?.text.toString() + "\n" + "请求login失败${t.message}"
                    super.onError(t)
                    WaitDialog.dismiss()
                    if (t.message == Constants.LOGIN_ERROR_NICK) {
                        mView?.onWriteNickName()
                    }
                }
            })
    }

    override fun startNext() {
        MainActivity.start(mView?.ctx!!)
        mView?.baseActivity?.finish()
    }

    override fun getSmsCode(phone: String) {
        Log.e("sms", "login")
        val hashMap = HashMap<String, Any>()
        hashMap["phone"] = phone
        RetrofitClient.retrofitService
            .getSmsCode(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                }

            })
    }

    private fun getUserInfo(phone: String) {
        RetrofitClient.retrofitService
            .getUserInfo()
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<LiveUserBean>() {
                override fun onSuccess(data: LiveUserBean?) {
                    UserHelper.userLoginSuccessForPhone(data, phone)
                    mView?.onLoginRequest()
                }
            })
    }

    override fun setTextView(tvMessage: TextView) {
        mTvMessage = tvMessage
    }

}