package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.MovieBean
import com.hupu.tv.player.app.ui.contact.MainCarefullyChosenFragmentContract
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class MainCarefullyChosenPresenter : IBasePresenter, MainCarefullyChosenFragmentContract.Presenter {
    private var mView: MainCarefullyChosenFragmentContract.Display? = null

    override fun attachView(view: IBaseDisplay?) {
        mView = view as MainCarefullyChosenFragmentContract.Display?
    }

    override fun detachView() {

    }






    override fun geMovieData(id: Int,pageNo:Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["pageNo"] = pageNo
        hashMap["pageSize"] = 10
        hashMap["twoCategoryId"] = id
        RetrofitClient.retrofitService
                .getMainMovieList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MovieBean>() {
                    override fun onSuccess(data: MovieBean?) {
                        mView?.onRequestMovie(data?.records)
                    }
                })
    }

}