package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback

import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.ClassifyBean
import com.hupu.tv.player.app.ui.contact.MainClassifyFragmentContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/7/3
 * @describe
 */
class MainClassifyFragmentPresenter : IBasePresenter, MainClassifyFragmentContact.Presenter {
    private var mView: MainClassifyFragmentContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MainClassifyFragmentContact.Display?
    }

    override fun detachView() {

    }

    override fun getClassifyList(mPageNo:Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["pageNo"] = mPageNo
        hashMap["pageSize"] = 10
        hashMap["userId"] = SPUtil[Constants.USER_ID,0] as Int
        RetrofitClient.retrofitService
                .getTikTokClassifyList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<ClassifyBean>() {
                    override fun onSuccess(data:ClassifyBean?) {
                        mView?.onRequestList(data?.dataList )
                    }
                })
    }
}