package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.LikeBean
import com.hupu.tv.player.app.bean.MovieBean
import com.hupu.tv.player.app.ui.contact.MainCollectionFragmentContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/7/3
 * @describe
 */
class MainCollectionFragmentPresenter : IBasePresenter, MainCollectionFragmentContact.Presenter {
    private var mView: MainCollectionFragmentContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MainCollectionFragmentContact.Display?
    }

    override fun detachView() {

    }

    override fun getCollectionList(pageNo: Int, isClearData:Boolean) {
        val hashMap = HashMap<String, Int>()
        hashMap["pageNo"] = pageNo
        hashMap["pageSize"] = 10
        hashMap["id"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .getCollectionList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MovieBean>() {
                    override fun onSuccess(data: MovieBean?) {
                        data?.let {
                            mView?.onRequestList(it.records as ArrayList<MovieBean.RecordsBean>,isClearData)
                        }
                    }
                })
    }

    override fun deleteMovie(movieId: Int?) {
        val hashMap = HashMap<String, Int>()
        hashMap["movieId"] = movieId ?: 0
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .collectMovie(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<LikeBean>() {
                    override fun onSuccess(data: LikeBean?) {
                        getCollectionList(1, true)
                    }
                })
    }

}