package com.hupu.tv.player.app.ui.presenter

import android.graphics.drawable.Drawable
import androidx.viewpager.widget.ViewPager
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.TextView
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.contact.MainContentAllContract
import com.hupu.tv.player.app.utils.JsonUtils
import com.hupu.tv.player.app.widget.ImageCarousel

/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class MainContentAllPresenter : IBasePresenter, MainContentAllContract.Presenter {
    private var mView: MainContentAllContract.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MainContentAllContract.Display?
    }

    override fun detachView() {
    }




    override fun reserveMatch(id: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] =id
        RetrofitClient.retrofitService
                .reserveMatch(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {
                        mView?.onSubscribeMatch(id,true)
                    }
                })
    }

    override fun reserveMatch(id: String, status: Boolean) {
        if (status){
            reserveMatch(id)
        }else{
            cancelReserveMatch(id)
        }
    }

    override fun cancelReserveMatch(id: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] =id
        RetrofitClient.retrofitService
                .cancelReserve(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {
                        mView?.onSubscribeMatch(id,false)
                    }
                })
    }


    override fun getMatchData(pageNo: Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["pageNum"] = pageNo
        hashMap["pageSize"] = 10
        RetrofitClient.retrofitService
                .liveHot(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<LiveBean>() {
                    override fun onSuccess(data: LiveBean?) {
//                        mView?.onRequestMovie(data)
                        mView?.onRequestLiveData(data?.dataList)
                    }
                })
    }

    override fun getTopLive(pageNo: Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["pageNum"] = pageNo
        hashMap["pageSize"] = 10
        RetrofitClient.retrofitService
                .liveHotTop(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MatchContentBean>() {
                    override fun onSuccess(data: MatchContentBean?) {
//                        mView?.onRequestMovie(data)
                        data?.matchLists?.let {
                            if (it.size > 0) {
                                mView?.onTopLiveData(it.get(0)?.matchInfos)
                            } else {
                                mView?.onTopLiveData(null)
                            }
                        }

                    }
                })
    }

}