package com.hupu.tv.player.app.ui.presenter

import android.graphics.drawable.Drawable
import androidx.viewpager.widget.ViewPager
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.TextView
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.contact.MainContentFragmentContract
import com.hupu.tv.player.app.utils.JsonUtils
import com.hupu.tv.player.app.widget.ImageCarousel

/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class MainContentPresenter : IBasePresenter, MainContentFragmentContract.Presenter {
    private var mView: MainContentFragmentContract.Display? = null
    private var imageInfoList = ArrayList<ImageInfo>()
    private var dots: ArrayList<View?>? = arrayListOf()
    private var imageCarousel: ImageCarousel? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MainContentFragmentContract.Display?
    }

    override fun detachView() {
        imageCarousel?.stopAutoPlay()
        imageCarousel?.adapter = null
        imageCarousel?.weakReference = null
        imageCarousel?.weakReferenceT = null
        imageCarousel?.weakReferenceV = null
        imageCarousel = null
        dots = null
    }


    private fun initData() {
        imageInfoList.add(ImageInfo(0, "图片1，公告1啦啦啦啦", "http://c.hiphotos.baidu.com/image/h%3D300/sign=cfce96dfa251f3dedcb2bf64a4eff0ec/4610b912c8fcc3ce912597269f45d688d43f2039.jpg"))
        imageInfoList.add(ImageInfo(1, "图片1，公告1啦啦啦啦", "http://d.hiphotos.baidu.com/image/pic/item/6159252dd42a2834a75bb01156b5c9ea15cebf2f.jpg"))
        imageInfoList.add(ImageInfo(2, "图片2，公告2啦啦啦啦", "http://c.hiphotos.baidu.com/image/h%3D300/sign=cfce96dfa251f3dedcb2bf64a4eff0ec/4610b912c8fcc3ce912597269f45d688d43f2039.jpg"))
        imageInfoList.add(ImageInfo(3, "图片3，公告3啦啦啦啦", "http://e.hiphotos.baidu.com/image/pic/item/6a600c338744ebf85ed0ab2bd4f9d72a6059a705.jpg"))
        imageInfoList.add(ImageInfo(4, "图片4，公告4啦啦啦啦", "http://b.hiphotos.baidu.com/image/h%3D300/sign=8ad802f3801001e9513c120f880e7b06/a71ea8d3fd1f4134be1e4e64281f95cad1c85efa.jpg"))
        imageInfoList.add(ImageInfo(5, "图片5，公告5啦啦啦啦", "http://e.hiphotos.baidu.com/image/h%3D300/sign=73443062281f95cab9f594b6f9177fc5/72f082025aafa40fafb5fbc1a664034f78f019be.jpg"))
        imageInfoList.add(ImageInfo(6, "图片6，公告6啦啦啦啦", "http://c.hiphotos.baidu.com/image/h%3D300/sign=cfce96dfa251f3dedcb2bf64a4eff0ec/4610b912c8fcc3ce912597269f45d688d43f2039.jpg"))
        imageInfoList.add(ImageInfo(7, "图片占位，公告占位啦啦啦啦", "http://d.hiphotos.baidu.com/image/pic/item/6159252dd42a2834a75bb01156b5c9ea15cebf2f.jpg"))
    }

    override fun initDot(linearLayout: LinearLayout, viewPager: ViewPager, textView: TextView) {
        if (imageCarousel == null) {
            val list = SPUtil.getSerializableObject<ArrayList<BannerBean>>(Constants.BANNER_LIST)
            linearLayout.removeAllViews()
            dots = addDots(linearLayout, mView?.baseActivity?.resources?.getDrawable(R.drawable.shape_dot_normal), list?.size
                    ?: 0)
            imageCarousel = mView?.baseFragment?.let { ImageCarousel(it, viewPager, textView, dots, Constants.IMAGE_CAROUSEL_TIME) }
            imageCarousel?.init(list)
            imageCarousel?.start()
            imageCarousel?.let {
                mView?.onDot(it)
            }
        }
    }

    override fun geMovieData(id: Int, pageNo: Int) {
        val hashMap = HashMap<String, Int>()
        hashMap["pageNo"] = pageNo
        hashMap["pageSize"] = 10
        hashMap["twoCategoryId"] = id
        RetrofitClient.retrofitService
                .getMovieList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MovieBean>() {
                    override fun onSuccess(data: MovieBean?) {
                        mView?.onAddFinish(data?.records as ArrayList<MovieBean.RecordsBean>)
                    }
                })

    }



    private fun addDots(linearLayout: LinearLayout, background: Drawable?, number: Int): ArrayList<View?>? {
        for (index in 2..number - 1) {    // 注意这里的 i 从 2 开始，只画出number个点
            var dotId = addDot(linearLayout, background)
            dots?.add(mView?.baseActivity?.findViewById(dotId))
        }
        return dots
    }


    /**
     * 动态添加一个点
     *
     * @param linearLayout 添加到LinearLayout布局
     * @param backgount    设置
     * @return 小点的Id
     */
    private fun addDot(linearLayout: LinearLayout, backgount: Drawable?): Int {
        var dot = View(mView?.baseActivity)
        var dotParams = LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT)
        dotParams.width = 16
        dotParams.height = 16
        dotParams.setMargins(4, 0, 4, 0)
        dot.layoutParams = dotParams
        dot.background = backgount
        dot.id = View.generateViewId()
        this.run {
            linearLayout.addView(dot)
        }
        return dot.id
    }


}