package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.MainTagBean
import com.hupu.tv.player.app.ui.contact.MainFindFragmentContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/7/3
 * @describe
 */
class MainFindFragmentPresenter : IBasePresenter, MainFindFragmentContact.Presenter {
    private var mView: MainFindFragmentContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MainFindFragmentContact.Display?
    }

    override fun detachView() {

    }

    override fun getFindList(mPage:Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["pageNo"] = mPage
        hashMap["pageSize"] = 10
        hashMap["userId"] = SPUtil[Constants.USER_ID,0] as Int
        RetrofitClient.retrofitService
                .getTikTokFindList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MainTagBean>() {
                    override fun onSuccess(data:MainTagBean?) {
                        mView?.onRequestList(data?.dataList)
                    }
                })
    }
}