package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.contact.MainHaveMaterialContract
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class MainHaveMaterialPresenter : IBasePresenter, MainHaveMaterialContract.Presenter {
    private var mView: MainHaveMaterialContract.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MainHaveMaterialContract.Display?
    }

    override fun detachView() {

    }

    override fun getBanner() {
        RetrofitClient.retrofitService
            .getBannerList(JsonUtils.toRequestBody(hashMapOf<String, Any>().apply {
                put("adType", 5)
            }))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<ArrayList<BannerBean>>() {
                override fun onSuccess(data: ArrayList<BannerBean>?) {
                    mView?.onBanner(data)
                }
            })
    }

    override fun getSpecialist(type: Int) {
        RetrofitClient.retrofitService
            .getSpecialist(JsonUtils.toRequestBody(hashMapOf<String, Any>().apply {
                put("type", type)
            }))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<MutableList<SpecialistBean>>() {
                override fun onSuccess(data: MutableList<SpecialistBean>?) {
                    mView?.onSpecialist(data)
                }
            })
    }

    override fun getSchedule(mPage: Int, pageSize: Int) {
        RetrofitClient.retrofitService
            .getMaterialSchedule(JsonUtils.toRequestBody(hashMapOf<String, Any>().apply {
                put("pageNum", mPage)
                put("pageSize", pageSize)
            }))
            .compose(NetworkTransformer(mView, false))
            .subscribe(object : RxCallback<MaterialScheduleEntity>() {
                override fun onSuccess(data: MaterialScheduleEntity?) {
                    mView?.onSchedule(data?.dataList)
                }
            })
    }
}