package com.hupu.tv.player.app.ui.presenter

import android.graphics.drawable.Drawable
import androidx.viewpager.widget.ViewPager
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.TextView
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.contact.MainNewsContentAllContract
import com.hupu.tv.player.app.utils.JsonUtils
import com.hupu.tv.player.app.widget.ImageCarousel

/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class MainNewsContentAllPresenter : IBasePresenter, MainNewsContentAllContract.Presenter {
    private var mView: MainNewsContentAllContract.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MainNewsContentAllContract.Display?
    }

    override fun detachView() {

    }


    override fun getNewsList(id: String, pageNo: Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["pageNum"] = pageNo
        hashMap["tagId"] = id
        hashMap["pageSize"] = 10
        RetrofitClient.retrofitService
                .getNewsList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<NewsDataBean>() {
                    override fun onSuccess(data: NewsDataBean?) {
                        mView?.onNewsData(data)
                    }
                })
    }
}