package com.hupu.tv.player.app.ui.presenter

import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.NewsTagItemEntity
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.hupu.tv.player.app.ui.contact.MainNewsFragmentContact
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback

/**
 * @author by Dell
 * @date on 2020/6/29
 * @describe
 */
class MainNewsFragmentPresenter : IBasePresenter, MainNewsFragmentContact.Presenter {
    private var mView: MainNewsFragmentContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MainNewsFragmentContact.Display?
    }

    override fun detachView() {

    }

    override fun getCategory() {

        RetrofitClient.retrofitService
                .getNewsTagList()
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<List<NewsTagItemEntity>>() {
                    override fun onSuccess(data: List<NewsTagItemEntity>?) {
                                mView?.onTagList(data)

                    }
                })
    }




}