package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.MainMovieBean
import com.hupu.tv.player.app.ui.contact.MainNormalFragmentContract
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class MainNormalPresenter : IBasePresenter, MainNormalFragmentContract.Presenter {
    private var mView: MainNormalFragmentContract.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MainNormalFragmentContract.Display?
    }

    override fun detachView() {

    }

    override fun geMovieData(id: Int,tagId:String) {
        val hashMap = HashMap<String, Any>()
        hashMap["twoCategoryId"] = id
        hashMap["tagIds"] = tagId
        hashMap["sortTag"] = Constants.TYPE_NORMAL
        RetrofitClient.retrofitService
                .getNewMovieTagList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<ArrayList<MainMovieBean>>() {
                    override fun onSuccess(data: ArrayList<MainMovieBean>?) {
                        mView?.onRequestMovie(data)
                    }
                })
    }

    override fun getMoreMoveData(id: Int, tagId: String,page:Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["twoCategoryId"] = id
        hashMap["tagIds"] = tagId
        hashMap["sortTag"] = Constants.TYPE_NORMAL
        hashMap["userId"] = SPUtil[Constants.USER_ID,0]
        hashMap["pageNo"] = page
        hashMap["pageSize"] = 10
        RetrofitClient.retrofitService
                .getNewMovieTagListMore(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<ArrayList<MainMovieBean>>() {
                    override fun onSuccess(data: ArrayList<MainMovieBean>?) {
                        mView?.onRequestMovieMore(data)
                    }
                })
    }


}