package com.hupu.tv.player.app.ui.presenter

import android.content.Intent
import com.hupu.tv.player.app.BuildConfig
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.ui.activity.MineBuyVipActivity
import com.hupu.tv.player.app.ui.activity.MineWalletActivity
import com.hupu.tv.player.app.ui.activity.ShareActivity
import com.hupu.tv.player.app.ui.contact.MainPagerFragmentContact
import com.hupu.tv.player.app.utils.JsonUtils
import me.jessyan.autosize.utils.LogUtils
import org.greenrobot.eventbus.EventBus

/**
 * @author by Dell
 * @date on 2020/6/29
 * @describe
 */
class MainPagerFragmentPresenter : IBasePresenter, MainPagerFragmentContact.Presenter {
    private var mView: MainPagerFragmentContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MainPagerFragmentContact.Display?
    }

    override fun detachView() {

    }

    override fun getTikTokMovieList(mPage: Int) {
        val hashMap = HashMap<String, Int>()
        hashMap["pageNo"] = mPage
        hashMap["pageSize"] = 10
        RetrofitClient.retrofitService
                .getTikTokList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<MovieBean>() {
                    override fun onSuccess(data: MovieBean?) {
                        data?.let {
                            mView?.onDataResponse(it.records)
                        }
                    }
                })
    }

    override fun getMovieDetail(movieId: Int?, position: Int) {
        LogUtils.e("viewPagerLayout movieDetail position:$position")
        val hashMap = HashMap<String, Int>()
        hashMap["movieId"] = movieId ?: 0
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .getMovieDetail(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<MovieDetailBean>() {
                    override fun onSuccess(data: MovieDetailBean?) {
                        LogUtils.e("viewPagerLayout onData position:$position")
                        mView?.onRequestMoveDetail(data, position)
                    }
                })
    }


    override fun clickCollect(movieId: Int?, position: Int) {
        val hashMap = HashMap<String, Int>()
        hashMap["movieId"] = movieId ?: 0
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .collectMovie(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<LikeBean>() {
                    override fun onSuccess(data: LikeBean?) {
                        mView?.onCollectionRefresh(data?.nums ?: 0, position)
//                        ToastUtil.s(data?.statusMessage)
                    }
                })
    }

    override fun moviePlay(movieId: Int?) {
        val hashMap = HashMap<String, Int>()
        hashMap["movieId"] = movieId ?: 0
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .playMovie(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<PlayMovieBean>() {
                    override fun onSuccess(data: PlayMovieBean?) {
                        refreshUserBean()
                        mView?.onPlayerMovie()
                    }
                })

    }


    fun refreshUserBean() {
        val hashMap = HashMap<String, Any>()
        hashMap["channel"] = SPUtil[Constants.CHANNEL_ID, BuildConfig.CHANNEL_ID]
        hashMap["code"] = SPUtil[Constants.SHARE_CODE, ""] as String
        RetrofitClient.retrofitService
                .login(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<UserBean>() {
                    override fun onSuccess(data: UserBean?) {
                        SPUtil.putSerializableObject(Constants.USER_BEAN, data)
                        SPUtil.put(Constants.USER_ID, data?.id)
                        EventBus.getDefault().post(RefreshUserEvent())
                    }
                })
    }

    override fun getWinnerList() {
        val hashMap = HashMap<String, Any>()
        hashMap["type"] = 1
        RetrofitClient.retrofitService
                .getWinnerListParam(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<List<String>>() {
                    override fun onSuccess(data: List<String>?) {
                        mView?.onWinnerRequest(data)
                    }
                })
    }

    override fun goShare() {
        mView?.baseActivity?.startActivity(Intent(mView?.baseActivity, ShareActivity::class.java))
    }

    override fun goVip() {
        mView?.baseActivity?.startActivity(Intent(mView?.baseActivity, MineBuyVipActivity::class.java))
    }

    override fun goWallet() {
        mView?.baseActivity?.startActivity(Intent(mView?.baseActivity, MineWalletActivity::class.java))
    }



}