package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.PromotionBean
import com.hupu.tv.player.app.ui.contact.MainPromotionFragmentContact

/**
 * @author by Dell
 * @date on 2020/7/3
 * @describe
 */
class MainPromotionFragmentPresenter : IBasePresenter, MainPromotionFragmentContact.Presenter {
    private var mView: MainPromotionFragmentContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MainPromotionFragmentContact.Display?
    }

    override fun detachView() {

    }

    override fun getPromotionList() {
        RetrofitClient.retrofitService
                .getPromotion()
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<List<PromotionBean>>() {
                    override fun onSuccess(data: List<PromotionBean>?) {
                        mView?.onRequestList(data as ArrayList<PromotionBean>?)
                    }
                })
    }
}