package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.MatchContentEntity
import com.hupu.tv.player.app.ui.contact.MatchContentFragmentContract
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class MatchContentPresenter : IBasePresenter, MatchContentFragmentContract.Presenter {
    private var mView: MatchContentFragmentContract.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MatchContentFragmentContract.Display?
    }

    override fun detachView() {

    }

    override fun getMatchList(id: String, status: Int, date: String, pageNum: Int, pageSize: Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] = id
        hashMap["status"] = status
        if (date.isNotEmpty()) {
            hashMap["startDate"] = date
            hashMap["endDate"] = date
        }
        hashMap["pageNum"] = pageNum
        hashMap["pageSize"] = pageSize
        RetrofitClient.retrofitService
            .getMatchList(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<MatchContentEntity>() {
                override fun onSuccess(data: MatchContentEntity?) {
                    if (data?.matchLists?.size ?: 0 > 0) {
                        mView?.onMatchList(data?.matchLists?.get(0)?.matchInfos)
                    } else {
                        mView?.onMatchList(null)
                    }
                }
            })

    }

    override fun reserveMatch(id: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
            .reserveMatch(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    mView?.onSubscribeMatch(id, true)
                }
            })
    }

    override fun reserveMatch(id: String, status: Boolean) {
        if (status) {
            reserveMatch(id)
        } else {
            cancelReserveMatch(id)
        }
    }

    override fun cancelReserveMatch(id: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
            .cancelReserve(JsonUtils.toRequestBody(hashMap))
            .compose(NetworkTransformer(mView))
            .subscribe(object : RxCallback<String>() {
                override fun onSuccess(data: String?) {
                    mView?.onSubscribeMatch(id, false)
                }
            })
    }

}