package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.contact.MatchDetailLiveContract
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class MatchDetailLivePresenter : IBasePresenter, MatchDetailLiveContract.Presenter {
    private var mView: MatchDetailLiveContract.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MatchDetailLiveContract.Display?
    }

    override fun detachView() {
    }


    override fun getMatchData(id: String, page: Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] =id
        RetrofitClient.retrofitService
                .getMatchDetail(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MatchDetailBean>() {
                    override fun onSuccess(data: MatchDetailBean?) {
                        mView?.onMatchDetail(data)
                    }
                })
    }



}