package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.MatchDetailBean
import com.hupu.tv.player.app.ui.contact.MatchDetailContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/8/31
 * @describe
 */
class MatchDetailPresenter : IBasePresenter, MatchDetailContact.Presenter {
    private var mView: MatchDetailContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MatchDetailContact.Display
    }

    override fun detachView() {

    }





    override fun getMatchDetail(id: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] =id
        RetrofitClient.retrofitService
                .getMatchDetail(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MatchDetailBean>() {
                    override fun onSuccess(data: MatchDetailBean?) {
                        mView?.onMatchDetail(data)
                    }
                })
    }
}