package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.RoomInfoBean
import com.hupu.tv.player.app.bean.TextLiveBean
import com.hupu.tv.player.app.ui.contact.MatchFootLiveFragmentContact
import com.hupu.tv.player.app.utils.JsonUtils


/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class MatchFootLiverFragmentPresenter : IBasePresenter, MatchFootLiveFragmentContact.Presenter {
    private var mView: MatchFootLiveFragmentContact.Display? = null

    override fun attachView(view: IBaseDisplay?) {
        mView = view as MatchFootLiveFragmentContact.Display?
    }

    override fun detachView() {

    }

    override fun getLiveData(id: String, pageNum:Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["pageNum"] = pageNum
        hashMap["pageSize"] = 10
//        hashMap["matchId"] = "fe9951736cca408086ce7a3ec511c87e"
        hashMap["matchId"] = id
        RetrofitClient.retrofitService
                .getMatchLive(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView,false))
                .subscribe(object : RxCallback<TextLiveBean?>() {
                    override fun onSuccess(data: TextLiveBean?) {
                        mView?.onLive(data?.dataList)
                    }
                })
    }




}