package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.TitleSortBean
import com.hupu.tv.player.app.ui.contact.MatchFragmentContact

/**
 * @author by Dell
 * @date on 2020/6/29
 * @describe
 */
class MatchFragmentPresenter :IBasePresenter, MatchFragmentContact.Presenter{
    private var mView:MatchFragmentContact.Display?=null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MatchFragmentContact.Display?
    }

    override fun detachView() {

    }

    override fun getMatchTitle() {
        RetrofitClient.retrofitService
                .getMatchTitle()
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<List<TitleSortBean>>() {
                    override fun onSuccess(data: List<TitleSortBean>?) {
                        mView?.onMatchTitleResponse(data)
                    }
                })
    }






}