package com.hupu.tv.player.app.ui.presenter


import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback

import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.MatchOddBasketEntity
import com.hupu.tv.player.app.bean.MatchOddEntity

import com.hupu.tv.player.app.ui.contact.MatchIndexContact

import com.hupu.tv.player.app.utils.JsonUtils


/**
 * @author by Dell
 * @date on 2020/8/31
 * @describe
 */
class MatchIndexPresenter : IBasePresenter, MatchIndexContact.Presenter {
    private var mView: MatchIndexContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MatchIndexContact.Display
    }

    override fun detachView() {

    }


    override fun getBasketBallOdds(id: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
                .getBasketballOdds(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MatchOddBasketEntity>() {
                    override fun onSuccess(data: MatchOddBasketEntity?) {
                        mView?.onBasketOdds(data)
                    }
                })
    }

    override fun getFootBallOdds(id: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
                .getFootBallOdds(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MatchOddEntity>() {
                    override fun onSuccess(data: MatchOddEntity?) {
                        mView?.onOdds(data)
                    }
                })
    }
}