package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.contact.MatchNewsContract
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class MatchNewsPresenter : IBasePresenter, MatchNewsContract.Presenter {
    private var mView: MatchNewsContract.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MatchNewsContract.Display?
    }

    override fun detachView() {

    }

    override fun getNewsList(id: String, pageNo: Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["pageNum"] = pageNo
        hashMap["matchId"] = id
        hashMap["pageSize"] = 10
        RetrofitClient.retrofitService
                .getMatchNews(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<NewsDataBean>() {
                    override fun onSuccess(data: NewsDataBean?) {
                        mView?.onNewsData(data)
                    }
                })
    }










}