package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.MessageBean
import com.hupu.tv.player.app.ui.contact.MessagelContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/8/31
 * @describe
 */
class MessagePresenter : IBasePresenter, MessagelContact.Presenter {
    private var mView: MessagelContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MessagelContact.Display
    }

    override fun detachView() {

    }

    override fun getMessage(mPage: Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["pageNum"] = mPage
        hashMap["pageSize"] = 10
        RetrofitClient.retrofitService
                .getMessageList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<MessageBean>() {
                    override fun onSuccess(data: MessageBean?) {
                        mView?.onMessage(data?.dataList)
                    }
                })
    }
}