package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.BuyCoinBean
import com.hupu.tv.player.app.ui.contact.MineBuyContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/7/13
 * @describe
 */
class MineBuyPresenter : IBasePresenter, MineBuyContact.Presenter {
    private var mView: MineBuyContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MineBuyContact.Display?
    }

    override fun detachView() {

    }

    override fun getBuyList(pageNo: Int) {
        val hashMap = HashMap<String, Int>()
        hashMap["pageNo"] = pageNo
        hashMap["pageSize"] = 10
        hashMap["userId"] = SPUtil[Constants.USER_ID, 0] as Int
//        hashMap["userId"] = 8523
        RetrofitClient.retrofitService
                .getBuyList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<BuyCoinBean>() {
                    override fun onSuccess(data: BuyCoinBean?) {
                        data?.let {
                            mView?.onRequestList(it.dataList)
                        }
                    }
                })
    }


}