package com.hupu.tv.player.app.ui.presenter

import android.content.Intent
import com.hupu.tv.player.app.BuildConfig
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.MovieBean
import com.hupu.tv.player.app.bean.UserBean
import com.hupu.tv.player.app.event.RefreshPageEvent
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.ui.activity.MineBuyVipActivity
import com.hupu.tv.player.app.ui.contact.MineFragmentContact
import com.hupu.tv.player.app.utils.JsonUtils
import org.greenrobot.eventbus.EventBus


/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class MineFragmentPresenter : IBasePresenter, MineFragmentContact.Presenter {
    private var mView: MineFragmentContact.IDisplay? = null

    override fun attachView(view: IBaseDisplay?) {
        mView = view as MineFragmentContact.IDisplay?
    }

    override fun detachView() {

    }

    override fun getDownloadList(bean: MovieBean.RecordsBean?) {
        var downloadList = SPUtil.getSerializableObject<ArrayList<MovieBean.RecordsBean>>(Constants.DOWNLOAD)
        if (downloadList == null || downloadList.isEmpty()) {
            downloadList = arrayListOf()
        }
        bean?.let {
            var isContaint = false
            run outside@{
                downloadList.forEach { movieBean ->
                    if (movieBean.videoFullUrl == it.videoFullUrl) {
                        isContaint = true
                        return@outside
                    }
                }
            }

            if (!isContaint) {
                downloadList.add(0, it)
            }
            SPUtil.putSerializableObject(Constants.DOWNLOAD, downloadList)
        }
        mView?.onRequestMovieDownloadList(downloadList)
    }


    override fun gotoVip() {
        mView?.baseActivity?.startActivity(Intent(mView?.baseActivity, MineBuyVipActivity::class.java))
    }

    override fun getMovieHistoryList() {
        val hashMap = HashMap<String, Int>()
        hashMap["pageNo"] = 1
        hashMap["pageSize"] = 10
        hashMap["id"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .getMovieHistory(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView, false))
                .subscribe(object : RxCallback<MovieBean>() {
                    override fun onSuccess(data: MovieBean?) {
                        //播放历史取4条数据展示
                        val list = arrayListOf<MovieBean.RecordsBean>()
                        run outside@{
                            data?.records?.forEachIndexed { index, recordsBean ->
                                //0,1,2,3 四条
                                if (index < 4) {
                                    list.add(recordsBean)
                                } else {
                                    return@outside
                                }
                            }
                        }

                        mView?.onRequestMovieHistoryList(list)
//                        if (BuildConfig.DEBUG) {
//                            ToastUtil.l(
//                                    "请求历史记录接口：movie/threeDaysPlay " +
//                                            "\n 参数：pageNo=1,pageSize=10" +
//                                            "\n请求成功")
//                        }
                    }
                })

    }


    override fun refreshDownloadList() {
        var downloadList = SPUtil.getSerializableObject<ArrayList<MovieBean.RecordsBean>>(Constants.DOWNLOAD)
        if (downloadList == null || downloadList.isEmpty()) {
            downloadList = arrayListOf()
        }
        mView?.onRequestMovieDownloadList(downloadList)
    }

    override fun refreshUserData() {
        val hashMap = HashMap<String, Any>()
        hashMap["channel"] = SPUtil[Constants.CHANNEL_ID, BuildConfig.CHANNEL_ID]
        hashMap["code"] = SPUtil[Constants.SHARE_CODE, ""] as String
        RetrofitClient.retrofitService
                .login(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<UserBean>() {
                    override fun onSuccess(data: UserBean?) {
                        if (data?.isVip != SPUtil[Constants.SP_IS_VIP, 0]) {
                            EventBus.getDefault().post(RefreshPageEvent())
                        }
                        SPUtil.put(Constants.SP_IS_VIP, data?.isVip)
                        SPUtil.putSerializableObject(Constants.USER_BEAN, data)
                        SPUtil.put(Constants.USER_ID, data?.id)
                        EventBus.getDefault().post(RefreshUserEvent())
                        mView?.onRefreshUserData()
                    }
                })

    }

    override fun getCollectionList() {
        val hashMap = HashMap<String, Int>()
        hashMap["pageNo"] = 1
        hashMap["pageSize"] = 10
        hashMap["id"] = SPUtil[Constants.USER_ID, 0] as Int
        RetrofitClient.retrofitService
                .getCollectionList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MovieBean>() {
                    override fun onSuccess(data: MovieBean?) {
                        val list = arrayListOf<MovieBean.RecordsBean>()
                        data?.let {
                            run outside@{
                                data.records?.forEachIndexed { index, recordsBean ->
                                    //0,1,2,3 四条
                                    if (index < 4) {
                                        list.add(recordsBean)
                                    } else {
                                        return@outside
                                    }
                                }
                            }
                            mView?.onRequestList(list)
                        }
                    }
                })
    }


}