package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.PayVipTypeBean
import com.hupu.tv.player.app.ui.contact.MineVipContract

/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class MineVipPresenter :IBasePresenter,MineVipContract.Presenter {
    private var mView :MineVipContract.Display?=null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MineVipContract.Display?
    }
    override fun detachView() {

    }


    override fun requestVipType() {
        RetrofitClient.retrofitService
                .getPayVipType()
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<List<PayVipTypeBean>>() {
                    override fun onSuccess(data: List<PayVipTypeBean>?) {
                        mView?.onRequest(data as ArrayList<PayVipTypeBean>)
                    }
                })


    }

    override fun requestRecharge() {
        RetrofitClient.retrofitService
                .getPayRecord()
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<List<String>>() {
                    override fun onSuccess(data: List<String>?) {
                        mView?.onRequestRecode(data as ArrayList<String>)
                    }
                })
    }


}