package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.CoinBean
import com.hupu.tv.player.app.ui.contact.MineWalletContract

/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class MineWalletPresenter :IBasePresenter, MineWalletContract.Presenter {
    private var mView :MineWalletContract.Display?=null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MineWalletContract.Display?
    }
    override fun detachView() {

    }


    override fun requestCoinList() {
        RetrofitClient.retrofitService
                .getCoinList()
                    .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<List<CoinBean>>() {
                    override fun onSuccess(data: List<CoinBean>?) {
                        mView?.onRequestRecode(data )
                    }
                })


    }

//    override fun requestRecharge() {
//        RetrofitClient.retrofitService
//                .getPayRecord()
//                .compose(NetworkTransformer(mView))
//                .subscribe(object : RxCallback<List<String>>() {
//                    override fun onSuccess(data: List<String>?) {
//                        mView?.onRequestRecode(data as ArrayList<String>)
//                    }
//                })
//    }


}