package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.MovieBean
import com.hupu.tv.player.app.ui.contact.MoreTagActivityContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/7/5
 * @describe
 */
class MoreTagActivityPresenter : IBasePresenter, MoreTagActivityContact.Presenter {
    private var mView: MoreTagActivityContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MoreTagActivityContact.Display?
    }

    override fun detachView() {

    }

    override fun searchData(twoCategoryId: Int,tagIds:Int, pageNo: Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["twoCategoryId"] = tagIds
        hashMap["tagIds"] = twoCategoryId
        hashMap["pageNo"] = pageNo
        hashMap["pageSize"] = 10
        RetrofitClient.retrofitService
                .getMainMovieList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MovieBean>() {
                    override fun onSuccess(data: MovieBean?) {
                        data?.records.let {
                            mView?.onSearchData(it as ArrayList<MovieBean.RecordsBean>?)
                        }
                    }
                })
    }
}



