package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.MainTagBean
import com.hupu.tv.player.app.bean.MovieBean
import com.hupu.tv.player.app.ui.contact.MovieTagActivityContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/7/5
 * @describe
 */
class MovieTagActivityPresenter : IBasePresenter, MovieTagActivityContact.Presenter {
    private var mView: MovieTagActivityContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as MovieTagActivityContact.Display?
    }

    override fun detachView() {

    }


    override fun getTagList(key: String, pageNo: Int) {
        val hashMap = HashMap<String, Any>()
        hashMap["UserId"] = SPUtil[Constants.USER_ID,0] as Int
        hashMap["tagName"] = key
        hashMap["pageNo"] = pageNo
        hashMap["pageSize"] = 10
        RetrofitClient.retrofitService
                .getMovieListByTag(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<MainTagBean>() {
                    override fun onSuccess(data: MainTagBean?) {
                        data?.dataList.let {
                            mView?.onSearchData(it as ArrayList<MovieBean.RecordsBean>?)
                        }
                    }
                })
    }
}



