package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.contact.NewMatchDetailContact
import com.hupu.tv.player.app.utils.JsonUtils

/**
 * @author by Dell
 * @date on 2020/8/31
 * @describe
 */
class NewMatchDetailPresenter : IBasePresenter, NewMatchDetailContact.Presenter {
    private var mView: NewMatchDetailContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as NewMatchDetailContact.Display
    }

    override fun detachView() {

    }





    override fun getBasketBall(id: String) {
        val hashMap = HashMap<String, String>()
//        hashMap["id"] = "f891705c0cc341db869545f6ffd8e9cb"
        hashMap["id"] = id
        RetrofitClient.retrofitService
                .getBasketballInfo(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView,false))
                .subscribe(object : RxCallback<MatchBasketballEntity?>() {
                    override fun onSuccess(data: MatchBasketballEntity?) {
                        mView?.onBasketBall(data)
                    }
                })

    }




    override fun getFootBall(id: String) {
        val hashMap = HashMap<String, String>()
//        hashMap["id"] = "ba7409798cbf43cd9fa62f26033fc185"
        hashMap["id"] = id
        RetrofitClient.retrofitService
                .getFootBallInfo(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView,false))
                .subscribe(object : RxCallback<MatchFootballBeanKt?>() {
                    override fun onSuccess(data: MatchFootballBeanKt?) {
                        mView?.onFootball(data)
                    }
                })

    }

    override fun getLiveList(id: String) {
        val hashMap = HashMap<String, String>()
//        hashMap["id"] = "dc0edfe0df0d4be6a04e328f8753c79b"
        hashMap["id"] = id
        RetrofitClient.retrofitService
                .getMatchLiveList(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView,false))
                .subscribe(object : RxCallback<MutableList<MatchLiveBean?>?>() {
                    override fun onSuccess(data:MutableList<MatchLiveBean?>?) {
                        mView?.onMatchLive(data)
                    }
                })

    }
}