package com.hupu.tv.player.app.ui.presenter

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.LiveUserBean
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.ui.contact.MineNewFragmentContact
import com.hupu.tv.player.app.utils.UserHelper
import org.greenrobot.eventbus.EventBus


/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class NewMineFragmentPresenter : IBasePresenter, MineNewFragmentContact.Presenter {
    private var mView: MineNewFragmentContact.IDisplay? = null

    override fun attachView(view: IBaseDisplay?) {
        mView = view as MineNewFragmentContact.IDisplay?
    }

    override fun detachView() {

    }


    override fun refreshUserData() {
        RetrofitClient.retrofitService
                .getUserInfo()
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<LiveUserBean>() {
                    override fun onSuccess(data: LiveUserBean?) {
                       UserHelper.userLoginSuccess(data)
                        mView?.onRefreshUserData()
                    }
                })

    }




}