package com.hupu.tv.player.app.ui.presenter


import com.hupu.tv.player.app.R
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback

import com.hupu.tv.player.app.api.RetrofitClient

import com.hupu.tv.player.app.bean.NewDetailEntity

import com.hupu.tv.player.app.ui.contact.NewsDetailContact
import com.hupu.tv.player.app.utils.JsonUtils
import com.softgarden.baselibrary.network.RxJava3NullException


/**
 * @author by Dell
 * @date on 2020/8/31
 * @describe
 */
class NewsDetailPresenter : IBasePresenter, NewsDetailContact.Presenter {
    private var mView: NewsDetailContact.Display? = null
    override fun attachView(view: IBaseDisplay?) {
        mView = view as NewsDetailContact.Display
    }

    override fun detachView() {

    }


    override fun getNewsDetail(id: String) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
                .getNewsDetail(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView))
                .subscribe(object : RxCallback<NewDetailEntity>() {
                    override fun onSuccess(data: NewDetailEntity?) {
                        mView?.onDetail(data)
                    }
                })
    }

    override fun clickLike(id: String,click:Boolean) {
        val hashMap = HashMap<String, Any>()
        hashMap["id"] = id
        RetrofitClient.retrofitService
                .clickNews(JsonUtils.toRequestBody(hashMap))
                .compose(NetworkTransformer(mView,isConfigStatus = false))
                .subscribe(object : RxCallback<String>() {
                    override fun onSuccess(data: String?) {
                        mView?.onClickSuccess(!click)
                    }
                })

    }
}